"use server"
import {getHeaders} from "@/app/actions/headers";
import {redirect} from "next/navigation";
import {UserResponse} from "@/app/actions/types/user";
import {cookies} from "next/headers";
import {revalidatePath} from "next/cache";

export async function login(initialState: any, formData: FormData) {
	const jsonData = Object.fromEntries(formData.entries());
	let nextUrl: string = '/'
	if(initialState){
		nextUrl = initialState?.next;
	}
	const res = await fetch(process.env.NEXT_PUBLIC_USER_API_URL + '/login', {
			method: 'POST',
			body: JSON.stringify(jsonData),
			headers: {
				'Content-Type': 'application/json'
			},
			cache: "no-store",
		}
	)

	if (!res.ok) {
		return { message: "Username or password is incorrect." };
	}
	const response = await res.json();
	if (!response) {
		return { message: "Invalid login response." };
	}
	const cookieStore = await cookies();
	cookieStore.set('session', JSON.stringify(response));
	revalidatePath("/", "layout");
	redirect(nextUrl);
}


export async function logout(redirectUrl: string = "/") {
	const headers = await getHeaders();
	const res = await fetch(process.env.NEXT_PUBLIC_USER_API_URL + '/auth/logout', {
		method: 'DELETE',
		headers: headers
	})
	const cookieStore = await cookies();
	cookieStore.set('session', '', {maxAge: 0})
	redirect(redirectUrl);
}

export async function getInfo(): Promise<UserResponse | null>{
	const headers = await getHeaders();
	const res = await fetch(process.env.NEXT_PUBLIC_USER_API_URL + '/auth/info', {
		headers: headers
	})
	const data = await res.json();
	return data as UserResponse;
}

export async function register(initialState: any, formData: FormData) {
	const jsonData = Object.fromEntries(formData.entries());
	const res = await fetch(process.env.NEXT_PUBLIC_USER_API_URL + '/register', {
			method: 'POST',
			headers: {
				'Content-Type': 'application/json'
			},
			body: JSON.stringify(jsonData),
	})
	try {
		const session = await res.json();
		const cookieStore = await cookies();
		cookieStore.set('session', JSON.stringify(session));
		redirect('/account');
		return {
			'message': 'Registration successful. Please login to continue.'
		}
	} catch (e) {
		console.log(e);
		return {
			'message': 'Registration unsuccessful. Please check your input and try again.'
		}
	}
}


export async function updatePassword(initialState: any, formData: FormData) {
	const headers = await getHeaders(true);
	const jsonData = Object.fromEntries(formData.entries());
	const res = await fetch(process.env.NEXT_PUBLIC_USER_API_URL + '/auth/password', {
		method: 'PUT',
		headers: headers,
		body: JSON.stringify(jsonData),
	});
	const result = await res.json() as boolean;
	if(result){
		await logout("/login");
	} else {
		return {
			message: 'Change password failed. Please try again.',
		}
	}
}