"use server"
import {cookies} from "next/headers";
import {redirect} from "next/navigation";


export async function getHeaders(required: boolean = true, pathname: string = "") {
	const cookieStore = await cookies();
	const token = cookieStore.get("session")?.value || "{}";
	const expires = JSON.parse(token).expires;
	if(required){
		if (token == "{}" || expires < Date.now()){
			redirect("/login?next=" + pathname + "");
		}
	}
	if (token == "{}"){
		return {
			'Content-Type': 'application/json',
			Authorization: ''
		}
	} else {
		return {
			Authorization: `Bearer ${JSON.parse(token).token}`,
			'Content-Type': 'application/json',
		}
	}
}